% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmncv.R
\name{plot.ggmncv}
\alias{plot.ggmncv}
\title{Plot \code{ggmncv} Objects}
\usage{
\method{plot}{ggmncv}(x, type = "pcor_path", size = 1, alpha = 0.5, color = "black", ...)
}
\arguments{
\item{x}{An object of class \code{ggmncv}}

\item{type}{Character string. Which type should be plotted ? Options included
\code{pcor_path}, \code{ic_path}, or \code{vip}.}

\item{size}{Numeric. The size of the points (\code{vip})  or lines (\code{pcor_path} or \code{ic_path})
The default is \code{1}.}

\item{alpha}{Numeric. The transparency of the lines. Only for the solution path options.}

\item{color}{Character string. The color of the points (\code{vip})  or lines
(\code{pcor_path} or \code{ic_path}). The default is \code{black}.}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot} object
}
\description{
Plot the solution path for the partial correlations, the information criterion solution path, or
the variable inclusion 'probabilities'.
}
\examples{

# data
Y <- GGMncv::ptsd[,1:10]

# correlations
S <- cor(Y, method = "spearman")

# fit model
fit <- GGMncv(x = S, n = nrow(Y),
              penalty = "atan",
              vip = TRUE,
              vip_iter = 50)

# plot
plot(fit, size = 4, type = "vip")

}
