% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl_ecdf.r
\name{GET.necdf}
\alias{GET.necdf}
\title{Graphical n sample test of correspondence of distribution functions}
\usage{
GET.necdf(
  x,
  r = seq(min(unlist((lapply(x, min)))), max(unlist((lapply(x, max)))), length = 100),
  contrasts = FALSE,
  nsim,
  ...
)
}
\arguments{
\item{x}{A list of numeric vectors, one for each sample.}

\item{r}{The sequence of argument values at which the distribution functions are to be compared.
The default is 100 equally spaced values between the minimum and maximum over all groups.}

\item{contrasts}{Logical. FALSE and TRUE specify the two test functions as described in
description part of this help file.}

\item{nsim}{The number of random permutations.}

\item{...}{Additional parameters to be passed to \code{\link{global_envelope_test}} (if \code{typeone = "fwer"})
or \code{\link{fdr_envelope}} (if \code{typeone = "fdr"}).}
}
\description{
Compare the distributions of two (or more) samples.
}
\details{
A global envelope test can be performed to investigate whether the n distribution functions
differ from each other and how do they differ. This test is a generalization of
the two-sample Kolmogorov-Smirnov test with a graphical interpretation.
We assume that the observations in the sample \eqn{i}{i} are an i.i.d. sample from the distribution
\eqn{F_i(r), i=1, \dots, n,}{F_i(r), i=1, ..., n,}
and we want to test the hypothesis
\deqn{F_1(r)= \dots = F_n(r).}{F_1(r)= ... = F_n(r).}
If \code{contrasts = FALSE} (default), then the test statistic is taken to be
\deqn{\mathbf{T} = (\hat{F}_1(r), \dots, \hat{F}_n(r))}{T = (\hat{F}_1(r), \dots, \hat{F}_n(r))}
where \eqn{\hat{F}_i(r) = (\hat{F}_i(r_1), \dots, \hat{F}_i(r_k))}{\hat{F}_i(r) = (\hat{F}_i(r_1), ..., \hat{F}_i(r_k))}
is the ecdf of the \eqn{i}{i}th sample evaluated at argument values
\eqn{r = (r_1,\dots,r_k)}{r = (r_1, ...,r_k)}.
This is our recommended test function for the test.
Another possibility is given by \code{contrasts = TRUE}, and then the test statistic is contructed from
all pairwise differences,
\deqn{\mathbf{T} = (\hat{F}_1(r)-\hat{F}_2(r), \hat{F}_1(r)-\hat{F}_3(r), \dots, \hat{F}_{n-1}(r)-\hat{F}_n(r))}{T = (\hat{F}_1(r)-\hat{F}_2(r), ..., \hat{F}_{n-1}(r)-\hat{F}_n(r))}

The simulations under the null hypothesis that the distributions are the same are obtained
by permuting the individuals of the groups. The default number of permutation, if nsim is not specified,
is n*1000 - 1 for the case \code{contrasts = FALSE} and
(n*(n-1)/2)*1000 - 1 for the case \code{contrasts = TRUE},
where n is the length of x.
}
\examples{
if(require(fda, quietly=TRUE)) {
  # Heights of boys and girls at age 10
  f.a <- growth$hgtf["10",] # girls at age 10
  m.a <- growth$hgtm["10",] # boys at age 10
  # Empirical cumulative distribution functions
  plot(ecdf(f.a))
  plot(ecdf(m.a), col='grey70', add=TRUE)
  # Create a list of the data
  fm.list <- list(Girls=f.a, Boys=m.a)
  \donttest{
  res_m <- GET.necdf(fm.list)
  plot(res_m)
  res_c <- GET.necdf(fm.list, contrasts=TRUE)
  plot(res_c)
  }
  \dontshow{
  # The test with lower number of simulations
  res_m <- GET.necdf(fm.list, nsim=4, alpha=0.2)
  plot(res_m)
  res_c <- GET.necdf(fm.list, contrasts=TRUE, nsim=4, alpha=0.2)
  plot(res_c)
  }

  # Heights of boys and girls at age 14
  f.a <- growth$hgtf["14",] # girls at age 14
  m.a <- growth$hgtm["14",] # boys at age 14
  # Empirical cumulative distribution functions
  plot(ecdf(f.a))
  plot(ecdf(m.a), col='grey70', add=TRUE)
  # Create a list of the data
  fm.list <- list(Girls=f.a, Boys=m.a)
  \donttest{
  res_m <- GET.necdf(fm.list)
  plot(res_m)
  res_c <- GET.necdf(fm.list, contrasts=TRUE)
  plot(res_c)
  }
  \dontshow{
  # The test with lower number of simulations
  res_m <- GET.necdf(fm.list, nsim=4, alpha=0.2)
  plot(res_m)
  res_c <- GET.necdf(fm.list, contrasts=TRUE, nsim=4, alpha=0.2)
  plot(res_c)
  }
}
}
