% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipseMeanSd.R
\name{calculateEllipse}
\alias{calculateEllipse}
\title{Calculate ellipse 'confidence region'}
\usage{
calculateEllipse(means, sd, alpha = 0.05)
}
\arguments{
\item{means}{A numeric vector of length 2 giving the mean for the x direction and the mean for the y direction.}

\item{sd}{A numeric vector of length 2 giving the standard deviation for the x direction and the y direction.}

\item{alpha}{A value between 0 and 1 that gives the confidence level.}
}
\value{
A list of length 2 containing:
\item{x}{The x axis coordinates of the ellipse}
\item{y}{The y axis coordinates of the ellipse}
}
\description{
Based on the mean and standard deviation of the elevation and rotation estimates this function
will determine the region over which a given proportion of points would be expected to fall.
}
\details{
Based on the mean and standard deviation of the x and y direction the limits of an ellipse are determined.
}
\keyword{internal}
