% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGDINA.R
\name{simDTM}
\alias{simDTM}
\title{Simulating data for diagnostic tree model}
\usage{
simDTM(N, Qc, gs.parm, Tmatrix, red.delta = NULL, att.gr = NULL)
}
\arguments{
\item{N}{sample size}

\item{Qc}{Association matrix between attributes (column) and PSEUDO items (row); The first column is item number and
the second column is the pseudo item number for each item. If a pseudo item has more than one nonzero categories,
more than one rows are needed.}

\item{gs.parm}{the same as the gs.parm in simGDINA function in the GDINA package. It is a list with the same number of
elements as the number of rows in the Qc matrix}

\item{Tmatrix}{mapping matrix showing the relation between the OBSERVED responses (rows) and the PSEDUO items (columns);
The first column gives the observed responses.}

\item{red.delta}{reduced delta parameters using logit link function}

\item{att.gr}{attribute group indicator}
}
\description{
Data generation for diagnostic tree model
}
\examples{
\dontrun{
K=5
g=0.2
item.no <- rep(1:6,each=4)
# the first node has three response categories: 0, 1 and 2
node.no <- rep(c(1,1,2,3),6)
Q1 <- matrix(0,length(item.no),K)
Q2 <- cbind(7:(7+K-1),rep(1,K),diag(K))
for(j in 1:length(item.no)) {
  Q1[j,sample(1:K,sample(3,1))] <- 1
}
Qc <- rbind(cbind(item.no,node.no,Q1),Q2)
Tmatrix.set <- list(cbind(c(0,1,2,3,3),c(0,1,2,1,2),c(NA,0,NA,1,NA),c(NA,NA,0,NA,1)),
cbind(c(0,1,2,3,4),c(0,1,2,1,2),c(NA,0,NA,1,NA),c(NA,NA,0,NA,1)),
cbind(c(0,1),c(0,1)))
Tmatrix <- Tmatrix.set[c(1,1,1,1,1,1,rep(3,K))]
sim <- simDTM(N=2000,Qc=Qc,gs.parm=matrix(0.2,nrow(Qc),2),Tmatrix=Tmatrix)
est <- DTM(dat=sim$dat,Qc=Qc,Tmatrix = Tmatrix)
}
}
