% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPVAF.Qval.R
\name{mesaplot}
\alias{mesaplot}
\title{Mesa plot for Q-matrix validation}
\usage{
mesaplot(Qval.obj, item, type = "best", no.qvector = 10,
  data.label = FALSE, original.q.label = TRUE, auto.ylim = TRUE, ...)
}
\arguments{
\item{Qval.obj}{model object of class \code{Qvalidation}}

\item{item}{a vector specifying which item(s) the plots are drawn for}

\item{type}{types of the plot. It can be \code{"best"} or \code{"all"}. If \code{"best"},
for all q-vectors requiring the same number of attributes, only the one with the largest PVAF
is plotted, which means \eqn{K_j} q-vectors are plotted; If \code{"all"}, all q-vectors
will be plotted.}

\item{no.qvector}{the number of q vectors that need to be plotted when \code{type="all"}. The default is 10,
which means the 10 q vectors with the largest PVAFs are plotted.}

\item{data.label}{logical; To show data label or not?}

\item{original.q.label}{logical; print the label showing the original q-vector or not?}

\item{auto.ylim}{logical; create y range automatically or not?}

\item{...}{additional arguments}
}
\description{
Mesa plot for Q-matrix validation
}
\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ
Q[1,] <- c(0,1,0)
mod1 <- GDINA(dat = dat, Q = Q, model = "GDINA")
out <- Qval(mod1,eps = 0.9)
item <- c(1,2,10)
mesaplot(out,item=item,data.label=TRUE,type="all")
mesaplot(out,item=10,type="best")
mesaplot(out,item=10,type="all",no.qvector=5)
}


}
\seealso{
\code{\link{Qval}}, \code{\link{autoGDINA}}
}
