#' @title Spatial datasets of vegetation index changes.
#'
#' @description "NDVI" dataset is the NDVI change data from 2010 to 2014 in Inner Mongolia, China.
#' This dataset consists of NDVI change and potential variables sampled from six sizes of
#' spatial grid units, including 5 km, 10 km, 20 km, 30 km, 40 km and 50 km.
#' The references of more details and data sources will be added.
#'
#' @name NDVI
#' @format
#' \code{ndvi_5}: A data frame with 46295 rows and 7 variables
#' \code{ndvi_10}: A data frame with 11567 rows and 7 variables
#' \code{ndvi_20}: A data frame with 2892 rows and 7 variables
#' \code{ndvi_30}: A data frame with 1290 rows and 7 variables
#' \code{ndvi_40}: A data frame with 713 rows and 7 variables
#' \code{ndvi_50}: A data frame with 469 rows and 7 variables
#' @docType data
#' @keywords dataset NDVI
"ndvi_5"

#' @rdname NDVI
"ndvi_10"
#' @rdname NDVI
"ndvi_20"
#' @rdname NDVI
"ndvi_30"
#' @rdname NDVI
"ndvi_40"
#' @rdname NDVI
"ndvi_50"

#' @title Spatial datasets of H1N1 flu incidences
#'
#' @description "H1N1" dataset is the provincial statistical incidences of
#' influenza A virus subtype H1N1 in China in 2013.
#' This dataset consists of H1N1 incidences and potential variables sampled from four sizes of
#' spatial grid units, including 10 km, 20 km, 50 km and 100 km.
#' The references of more details and data sources will be added.
#'
#' @name H1N1
#' @format
#' \code{h1n1_50}: A data frame with 3977 rows and 11 variables
#' \code{h1n1_100}: A data frame with 987 rows and 11 variables
#' \code{h1n1_150}: A data frame with 443 rows and 11 variables
#' @docType data
#' @keywords dataset H1N1
"h1n1_50"

#' @rdname H1N1
"h1n1_100"
#' @rdname H1N1
"h1n1_150"
