% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions.R
\name{multilevel}
\alias{multilevel}
\title{Full estimation of the multilevel factor model}
\usage{
multilevel(
  data,
  ic = "BIC3",
  standarise = TRUE,
  r_max = 10,
  r0 = NULL,
  ri = NULL,
  depvar_header = NULL,
  i_header = NULL,
  j_header = NULL,
  t_header = NULL
)
}
\arguments{
\item{data}{Either a data.frame or a list of data matrices of length \eqn{R}. See \strong{Details}.}

\item{ic}{A character string of selection criteria to use for estimation of the numbers of local factors. See \strong{Details}.}

\item{standarise}{A logical indicating whether the data is standardised before estimation or not. See \strong{Details}.}

\item{r_max}{An integer indicating the maximum number of factors allowed. See \strong{Details}.}

\item{r0}{An integer of the number of global factors. See \strong{Details}.}

\item{ri}{An array of length \eqn{R} containing the number of local factors in each block. See \strong{Details}.}

\item{depvar_header}{A character string specifying the header of the dependent variable. See \strong{Details}.}

\item{i_header}{A character string specifying the header of the block identifier. See \strong{Details}.}

\item{j_header}{A character string specifying the header of the individual identifier. See \strong{Details}.}

\item{t_header}{A character string specifying the header of the time identifier. See \strong{Details}.}
}
\value{
The return value is an S3 object of class "multi_result".
It contains a list of the following items:
\itemize{

\item G = A matrix of the estimated global factors.
\item Gamma = A list of length \eqn{R} containing matrices of the estimated global loading matrices for each block.
\item F = A list of length \eqn{R} containing matrices of the estimated local factors for each block.
\item Lambda = A list of length \eqn{R} containing matrices of the estimated global loading matrices for each block.
\item N = The total number of cross-sections in the panel.
\item Ni = An array of length \eqn{R} containing the number of cross-sections in each block.
\item r0 = The number of global factors. Unchanged if pre-specified.
\item ri = An array of length \eqn{R} containing the number of local factors for each block. Unchanged if pre-specified.
\item d = An array of length \eqn{R} containing the maximum total number of factors allowed for each block.
The elements are identically equal to r_max if either r0 or ri is supplied as NULL.
\item Resid = A list of length \eqn{R} containing the residual matrices for each block.
\item delta2 = An array of the mock and the \eqn{r_{\max} + 1} largest squared singular values.
\item ic = Selection criteria used for estimating the numbers of local factors.
\item block_names = A array of block names.

}
}
\description{
This is the main function of this package which performs full estimation
of the multilevel factor model.
}
\details{
The user-supplied data.frame should contain at least four columns, namely the
dependent variable (\eqn{y_{ijt}}), block identifier (\eqn{i}), individual
identifier (\eqn{j}), and time (\eqn{t}). The user needs to supply their corresponding
headers in the data.frame to the function using the parameters "depvar_header",
"i_header", "j_header", and "t_header", respectively. If the data is supplied
as a list, these arguments will not be used.

If either r0 = NULL or ri = NULL, then both of them will be estimated.
In such case, "r_max" must be supplied. If "r0" and "ri" are supplied then
"r_max" is not needed and will be ignored.

If standarise = TRUE, each time series will be standardised so it has zero mean
and unit variance. It is recommended to standardise the data before estimation.

See Lin and Shin (2025) for more details.
}
\examples{

panel <- UKhouse # load the data

# use data.frame
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
# or one can use a list of data matrices
Y_list <- panel2list(panel, depvar_header = "dlPrice", i_header = "Region",
                                       j_header = "LPA_Type", t_header = "Date")
est_multi <- multilevel(Y_list, ic = "BIC3", standarise = TRUE, r_max = 5)
}
\references{
Lin, R. and Shin, Y., 2025. Generalised Canonical Correlation Estimation
of the Multilevel Factor Model. Available at SSRN 4783804.
}
