% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf_counts_annot.R
\name{vcf_counts_annot}
\alias{vcf_counts_annot}
\title{gene annotation counts using VCF data}
\usage{
vcf_counts_annot(
  vcf_data,
  df_snpgene,
  keep_indiv = NULL,
  extract_SNP = NULL,
  filter_gene = NULL
)
}
\arguments{
\item{vcf_data}{an object of vcfR class}

\item{df_snpgene}{a data frame that contains SNP and annotated gene with SNP and GENE as column name}

\item{keep_indiv}{an option to specify individuals to retain. Mutation counts will be provided for individuals included in the list only. Default is all individuals. Provide list of individuals in a vector.}

\item{extract_SNP}{an option to specify SNPs for which mutation counts are needed. Mutation counts will be provided for SNPs included in the list only. Default is all SNPs.}

\item{filter_gene}{an option to filter in a list of Genes. Mutation counts will be provided for genes specifed in the list only. Default is all genes. Provide list of genes in a vector.}
}
\value{
Returns an matrix of data.table class as an output with allelic (reference) gene counts within each sample where each row corresponds to gene and column to individual IDs from column second. The first column contains gene names.
}
\description{
Function returns a matrix with allelic (reference) counts per gene per individual for SNP-gene annotation
}
\details{
Inputs needed are a vcf data and a data frame of SNP-gene annotation. The function returns a matrix of allelic counts (reference) per gene per sample (where each row represents a gene and each column represents an individual starting with the second column where first column contains gene information).
}
\examples{
\dontrun{
vcf_counts_annot(vcf,df_snpgene_test)
}

}
\author{
Sanjeev Sariya
}
