% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyGaussianNaiveBayes.R
\name{FuzzyGaussianNaiveBayes}
\alias{FuzzyGaussianNaiveBayes}
\title{Gaussian Naive Bayes Classifier}
\usage{
FuzzyGaussianNaiveBayes(train, cl, cores = 2, fuzzy = TRUE)
}
\arguments{
\item{train}{matrix or data frame of training set cases.}

\item{cl}{factor of true classifications of training set}

\item{cores}{how many cores of the computer do you want to use (default = 2)}

\item{fuzzy}{boolean variable to use the membership function}
}
\value{
A vector of classifications
}
\description{
\code{FuzzyGaussianNaiveBayes} Gaussian Naive Bayes Classifier Zadeh-based
}
\examples{

set.seed(1) # determining a seed
data(iris)

# Splitting into Training and Testing
split <- caTools::sample.split(t(iris[, 1]), SplitRatio = 0.7)
Train <- subset(iris, split == "TRUE")
Test <- subset(iris, split == "FALSE")
# ----------------
# matrix or data frame of test set cases.
# A vector will be interpreted as a row vector for a single case.
test <- Test[, -5]
fit_GNB <- FuzzyGaussianNaiveBayes(
  train = Train[, -5],
  cl = Train[, 5], cores = 2
)

pred_GNB <- predict(fit_GNB, test)

head(pred_GNB)
head(Test[, 5])
}
\references{
\insertRef{marcos2012online}{FuzzyClass}
}
