\name{ConsensusPartition}
\alias{ConsensusPartition}
\title{
  Consensus of Partitions
}
\description{
  Returns the consensus partition among a set of partitions
}
\usage{
ConsensusPartition(Part, ngroups = 0, type = "cutree", optim = FALSE, 
            maxiter = 100, plotDendrogram = FALSE, verbose = FALSE)
}
\arguments{
  \item{Part}{
    Object of class \code{SortingPartition}
}
  \item{ngroups}{
    Number of groups of the consensus (or \code{ngroups=0} for optimal choice)
}
  \item{type}{
    Method  (\code{type="cutree"} or \code{type="fusion"} or \code{type="medoid"})
}
  \item{optim}{
    Optimisation of the consensus (default is \code{optim=FALSE})
}
  \item{maxiter}{
    Maximum number of iterations for fusion algorithm
}
  \item{plotDendrogram}{
    Plot of the dendrogram (if \code{type="cutree"} initialisation)
}
  \item{verbose}{
    Print the initialisation results
}
}
\details{
The criterion for optimal consensus is the mean adjusted Rand Index between the consensus and the partitions given by the subjects.

If \code{ngroups=0}, consensus is computed between 2 and nstimuli-1 and the best consensus is returned.

For \code{type="cutree"}, the initialisation step is based on cutting the tree generated by clustering the stimuli. For \code{type="fusion"}, the initialisation step is based on the fusion algorithm. In this case, results are more accurate but the algorithm might be time consuming. For \code{type="medoid"}, the consensus is the closest partition to all the partitions given by subjects.

For  \code{ optim=TRUE}, a transfer step is performed after the initialisation step.
}
\value{
  List of following components:
    \item{Consensus }{Consensus}
    \item{Crit }{Criterion for consensus}
}
\references{
  Krieger & Green (1999) J. of Classification, 16:63-89
}
\examples{
  data(AromaSort)
  Aroma<-SortingPartition(AromaSort)
  res<-ConsensusPartition(Aroma,ngroups=0,type="cutree")
  res
  ##res<-ConsensusPartition(Aroma,ngroups=0,type="fusion",optim=TRUE)
  ##res
  ##res<-ConsensusPartition(Aroma,type="medoid")
  ##res
  
}