% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampling.R
\name{remove.stem.fossils}
\alias{remove.stem.fossils}
\title{Remove fossil samples that occur in the stem}
\usage{
remove.stem.fossils(fossils, tree)
}
\arguments{
\item{fossils}{an object of class "fossils" that corresponds to fossil
occurrences for "tree".}

\item{tree}{an object of class "Phylo".}
}
\value{
an object of class "fossils", containing only the fossil samples that
  occur in the crown.
}
\description{
Remove fossil samples that occur in the stem
}
\examples{
t = TreeSim::sim.bd.taxa(10, 1, 0.1, 0.05)[[1]]
f = sim.fossils.poisson(0.1, t, root.edge = FALSE)
remove.stem.fossils(f, t)
}
