% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEAST.output.R
\name{fossils.to.BEAST.constraints}
\alias{fossils.to.BEAST.constraints}
\title{Create a set of BEAST2 constraints to construct a DPPDIV style fixed extant
topology FBD analysis}
\usage{
fossils.to.BEAST.constraints(fossils, tree,
  file = "BEASTconstraints.xml", complete = FALSE,
  tree.name = "beastTree")
}
\arguments{
\item{fossils}{an object of class "fossils" that corresponds to fossil
occurrences for the "tree" argument.}

\item{tree}{an object of class "phylo", representing the tree upon which the
fossil occurrences were simulated.}

\item{file}{the name of the file to which the constraints will be written,
defaults to "BEASTconstraints.xml".}

\item{complete}{logical, if TRUE then taxon constraints are built for the
complete tree, if FALSE then constraints are built for the crown clades
only. Default value is FALSE.}

\item{tree.name}{the name of the tree as used in the BEAST2 xml format.}
}
\value{
NULL.
}
\description{
If complete = FALSE, only the extant taxa are used to construct the taxon
constraints, resulting in a DPPDIV style analysis in which the extant
topology is fixed and fossils can float in the tree. The resulting output uses the stronglyMonophyletic
taxon constraint on the root, this means that all fossil taxa will be sampled in the crown group, and never
in a position below the root.
}
\examples{
t = TreeSim::sim.bd.taxa(10, 1, 0.1, 0.05)[[1]]
f = sim.fossils.poisson(0.1, t, root.edge = FALSE)
fossils.to.BEAST.constraints(f, t, complete = TRUE)
}
