% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{beast.fbd.format}
\alias{beast.fbd.format}
\title{Transforms a tree and fossils into a sampled tree in beast-usable format and writes it in Newick format.
Designed to work with FBD.}
\usage{
beast.fbd.format(tree, fossils, rho = 1, sampled_tips = NULL, ...)
}
\arguments{
\item{tree}{Complete tree.}

\item{fossils}{fossils dataframe.}

\item{rho}{Sampling probability of extant tips. Default 1, will be disregarded if sampled_tips is not null.}

\item{sampled_tips}{List of tip labels corresponding to sampled extant tips.}

\item{...}{Additional parameters will be passed to ape::write.tree}
}
\value{
Output of write.tree.
}
\description{
Transforms a tree and fossils into a sampled tree in beast-usable format and writes it in Newick format.
Designed to work with FBD.
}
\examples{
# simulate tree
t = ape::rtree(6)

# simulate fossils
f = sim.fossils.poisson(rate = 2, tree = t)

# output for BEAST
beast.fbd.format(t, f) # output on the console
beast.fbd.format(t, f, file="example.tre") # output in file
}
