% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glcm.R
\name{glcm}
\alias{glcm}
\title{Grey level covariance matrix}
\usage{
glcm(segs, image, n_grey = 32, clusters = 1, showprog = FALSE)
}
\arguments{
\item{segs}{RasterLayer. A segmented raster. Cell values should be equal to segment numbers}

\item{image}{RasterLayer. A single-band raster layer from which texture is measured}

\item{n_grey}{integer. Number of grey levels the image should be quantized into}

\item{clusters}{integer. Number of clusters to use during parallel processing}

\item{showprog}{logical. Display progress in terminal}
}
\value{
data.frame
}
\description{
Generate textural metrics for a segmented raster using grey level covariance matrices (GLCM).
Implements the \code{glcm} function from the \link[radiomics:glcm]{radiomics} package.
}
\examples{
\dontrun{
# Generate raster segments
segs <- mcws(kootenayTrees, kootenayCHM, minHeight = 0.2, format = "raster")

# Get textural metrics for ortho's red band
tex <- glcm(segs, kootenayOrtho[[1]])
}

}
