% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_stand_spatial.R
\name{new_fe_stand_spatial}
\alias{new_fe_stand_spatial}
\title{Constructor for the \strong{fe_stand_spatial} Class}
\usage{
new_fe_stand_spatial(x = list(), ..., class = character())
}
\arguments{
\item{x}{An appropriate \code{list} object}

\item{...}{Additional arguments required for enabling subclasses of
\code{fe_stand_spatial}}

\item{class}{A Character string required for enabling subclasses of
\code{fe_stand_spatial}}
}
\value{
An object of class \code{fe_stand_spatial}
}
\description{
Should be used by expert users only who know exactly what they are doing.
Other users please take the function \code{\link{fe_stand}} for creating an
object of that class.
}
\examples{
#' # Constructing a minimal fe_stand_spatial object from scratch
# Use fe_stand_spatial() if you are not absolutely sure

trees <- data.frame(
  tree_id = as.character(c(1:50)),
  species_id = as_fe_species_tum_wwk_short(rep("5", 50)),
  layer_key = 1,
  time_yr = 2024,
  dbh_cm = rnorm(50, 50, 8),
  age_yr = NA_real_,
  height_m = NA_real_,
  crown_base_height_m = NA_real_,
  crown_radius_m = NA_real_,
  removal = FALSE,
  ingrowth = FALSE,
  n_rep_ha = 1 / 0.75
)

# generate tree positions

tree_positions <- data.frame(
 tree_id = as.character(c(1:50)),
 x_pos = runif(50, 1, 49),
 y_pos = runif(50, 1, 49)
 ) |> sf::st_as_sf(coords = c("x_pos", "y_pos"))


fe_stand_spatial_candidate <- list(
  stand_id = "my_interesting_stand",
  outline = NULL,
  orientation = 0,
  small_trees = data.frame(),
  trees = trees,
  tree_positions = tree_positions
)

fe_stand_object <- new_fe_stand_spatial(fe_stand_spatial_candidate)

# Better validate it
fe_stand_object |> validate_fe_stand_spatial()



}
