% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weather.R
\name{NOAA_getGSOD}
\alias{NOAA_getGSOD}
\title{Get daily weather summaries from NOAA}
\usage{
NOAA_getGSOD(stations, years, match.columns = "station.name",
  progress = TRUE)
}
\arguments{
\item{stations}{A \code{data.frame} with the stations for which data are to be
retrieved. It can be a subset of the \code{data.frame}s returned from
\code{\link{NOAA_allStations}} or \code{\link{NOAA_countryStations}}.
At a minimum it should contain columns 'usaf' and 'wban'.}

\item{years}{An integer vector of years (from 1901 to current year)
for which data are to be retrieved.}

\item{match.columns}{\code{NULL} or (optionally) a vector of column names that
can be found in \code{stations}. If given, these are included in the output
after matching with the respective weather stations.}

\item{progress}{If \code{TRUE} (the default), a progress bar appears if more
  than three files are to be downloaded from NOAA. Set to \code{FALSE} to suppress
  the progress bar.

  For example, one can include a grouping variable in \code{stations} (such as
  region code) and give its name in \code{match.columns} for it to be included in
  the function output. This facilitates aggregating the output by the grouping variable.}
}
\value{
A \code{data.frame} with the following columns (adapted from NOAA):
  \describe{
    \item{usaf}{Air Force station ID}
    \item{wban}{NCDC WBAN number}
    \item{date}{Date (of class \code{Date}}
    \item{temp}{Mean temperature for the day, in degrees Celsius to tenths.}
    \item{tempC}{Number of observations used in calculating mean temperature.}
    \item{dewp}{Dew point for the day, in degrees Celsius to tenths.}
    \item{dewpC}{Number of observations used in calculating mean dew point.}
    \item{slp}{Mean sea level pressure for the day,in millibars to tenths.}
    \item{slpC}{Number of observations used in calculating mean sea level pressure.}
    \item{stp}{Mean station pressure for the day in millibars to tenths.}
    \item{stpC}{Number of observations used in calculating mean station pressure.}
    \item{visib}{Mean visibility for the day in miles to tenths.}
    \item{visibC}{Number of observations used in calculating mean visibility.}
    \item{wdsp}{Mean wind speed for the day in knots to tenths.}
    \item{wdspC}{Number of observations used in calculating mean wind speed.}
    \item{mxspd}{Maximum sustained wind speed reported for the day, in knots to tenths.}
    \item{gust}{Maximum wind gust reported for the day, in knots to tenths.}
    \item{maxtemp}{Maximum temperature reported during the day,
      in degrees Celsius to tenths. Time of max temp report varies
      by country and region, so this will sometimes not be the max for the calendar day.}
    \item{maxtempF}{Blank indicates max temp was taken from the explicit max temp report
      and not from the 'hourly' data. An asterisk (*) indicates max temp was derived from
      the hourly data (i.e., highest hourly or synoptic-reported temperature).}
    \item{mintemp}{Minimum temperature reported during the day,
      in degrees Celsius to tenths. Time of min temp report varies
      by country and region, so this will sometimes not be the min for the calendar day.}
    \item{mintempF}{Blank indicates min temp was taken from the explicit min temp report
      and not from the 'hourly' data. An asterisk (*) indicates min temp was derived from
      the hourly data (i.e., lowest hourly or synoptic-reported temperature).}
    \item{prcp}{Total precipitation (rain and/or melted snow) reported during the day,
      in inches and hundredths; will usually not end with the midnight observation,
      i.e. may include latter part of previous day. Zero indicates no measurable
      precipitation (includes a trace).
      Note:  Many stations do not report '0' on days with no precipitation, therefore
      \code{NA} will often appear on these days. Also, for example, a station may only
      report a 6-hour amount for the period during which rain fell. See 'prcpF' field
      for source of data.}
    \item{prcpF}{A = 1 report of 6-hour precipitation amount.
      B = Summation of 2 reports of 6-hour precipitation amount.
      C = Summation of 3 reports of 6-hour precipitation amount.
      D = Summation of 4 reports of 6-hour precipitation amount.
      E = 1 report of 12-hour precipitation amount.
      F = Summation of 2 reports of 12-hour precipitation amount.
      G = 1 report of 24-hour precipitation amount.
      H = Station reported '0' as the amount for the day (eg, from 6-hour reports),
      but also reported at least one occurrence of precipitation in hourly observations;
      this could indicate a trace occurred, but should be considered as incomplete data
      for the day.
      I = Station did not report any precip data for the day and did not report
      any occurrences of precipitation in its hourly observations; it's still possible
      that precip occurred but was not reported.}
    \item{sndp}{Snow depth in inches to tenths--last report for the day
      if reported more than once. Note:  Most stations do not report '0' on days with
      no snow on the ground--therefore, \code{NA} will often appear on these days.}
    \item{frshtt}{Indicators (1 = yes, 0 = no/not reported) for the occurrence during
      the day of: Fog ('F' - 1st digit); Rain or Drizzle ('R' - 2nd digit); Snow or Ice
      Pellets ('S' - 3rd digit); Hail ('H' - 4th digit); Thunder ('T' - 5th digit);
      Tornado or Funnel Cloud ('T' - 6th digit).}
  }

 Note that, compared to the original NOAA output (for details see
 \url{ftp://ftp.ncdc.noaa.gov/pub/data/gsod/readme.txt}),
 all temperatures are automatically converted to degrees Celsius (instead of Fahrenheit)
 and all missing indicators are replaced with \code{NA}s.
}
\description{
Downloads the daily weather summaries for a set of weather stations
and a set of years.
}
