% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NA.sum.r
\name{NA.sum}
\alias{NA.sum}
\title{Sum missing data points from a daily time series}
\usage{
NA.sum(input, by = "hyear", hyrstart = 1)
}
\arguments{
\item{input}{output from \code{\link{NA.runs}}}

\item{by}{character string identifying the time period to summarize by.
Defaults is hydrologic year ("hyear"), other choices are "year" and "month".
The "month" option will return the number of missing data points for each
month in the time series.}

\item{hyrstart}{optional argument, define start month of hydrologic year}
}
\value{
Returns a numeric vector of the number of missing observations per
  summary period.  The "times" attribute of the returned vector provides the
  corresponding year, hyear, or month.
}
\description{
Counts the number of missing data points by calendar year, hydrologic year, or month
}
\examples{
data(caniapiscau)
cania.sub <- caniapiscau[300:1200,]
cania.ts <- create.ts(cania.sub)
res <- NA.runs(cania.ts)
res2 <- NA.sum(res)
}
\author{
Jennifer Dierauer
}
\seealso{
\code{\link{NA.runs}}
}

