% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flget_area.R
\name{flget_area}
\alias{flget_area}
\title{Extract pixel surface area data from a NetCDF file downloaded by \code{FjordLight}.}
\usage{
flget_area(fjord, mode = "raster")
}
\arguments{
\item{fjord}{Expects the object loaded via \code{\link{fl_LoadFjord}}.}

\item{mode}{Determines the format to be loaded into the R environment.
The default \code{"raster"} will load the data as a raster format. \code{"3col"}
will load the data as a data.frame with three columns.}
}
\value{
Depending on which arguments the user chooses, this function will return the
surface area data as a \code{RasterLayer} (\code{mode = "raster"}) or
data.frame (\code{mode = "df"}). The data.frame will contain the following columns:
  \item{longitude}{degree decimals}
  \item{latitude}{degree decimals}
  \item{PixelArea_km2}{the surface area of the grid cell [km^2]}
}
\description{
This functions will conveniently extract the pixel surface area data stored within a
NetCDF file downloaded via \code{\link{fl_DownloadFjord}}. The user may choose to
load the data in either raster or data.frame formats. It is useful to combine these
data with others, e.g. bathymetry data loaded via \code{\link{fl_DownloadFjord}}
}
\examples{
# Load data
fjord_code <- "test"
fjorddata <- fl_LoadFjord(fjord_code, dirdata = system.file("extdata", package = "FjordLight"))

# Load area data
area <- flget_area(fjorddata, mode = "df")

}
\author{
Bernard Gentili & Robert Schlegel
}
