% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.activity.R
\name{QC.activity}
\alias{QC.activity}
\title{Quality Control of Animal Activity}
\usage{
QC.activity(clean.data, compare = TRUE)
}
\arguments{
\item{clean.data}{a data frame obtained by using the function \code{\link{correct.meas}}}

\item{compare}{logical: if TRUE then two graphs are plotted to compare mass-specific metabolic rate before and after correction for background respiration}
}
\description{
Graphical quality control tests for animal activity in chambers over the period of measurements defined in the function \code{\link{correct.meas}}. The function is used for determination of time period for calculation of standard or resting metabolic rate. Note, that mass-specific metabolic rate is calculated for each period of measurements (not raw data).
}
\details{
QC.activity uses functions \code{\link{extract.slope}} and \code{\link{calculate.MR}} with default parameters (excluding \eqn{r^{2} = 0}) to plot a graph of animal activity
}
\examples{
# if the data have been already loaded to R,
# skip the first line of the code:
data(SMR.clean)

QC.activity(SMR.clean, compare = TRUE)

}
