% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_corr_mat.R
\name{rand_cor_mat}
\alias{rand_cor_mat}
\title{Random correlation matrix}
\usage{
rand_cor_mat(p, min_cor = -1, max_cor = 1, pos_def = FALSE)
}
\arguments{
\item{p}{A scalar defining the dimensions of the correlation matrix.}

\item{min_cor}{A scalar defining the minimum potential value.}

\item{max_cor}{A scalar defining the maximum potential value.}

\item{pos_def}{When \code{TRUE}, the function 'bend' of the package
\href{https://cran.r-project.org/package=mbend}{`mbend'} is used with default arguments to
bend a non-positive-definite correlation matrix to a positive-definite matrix (when
appropriate). By default, \code{pos_def = FALSE}.}
}
\value{
A symmetric \code{p x p} correlation matrix.
}
\description{
Creates a symmetric \code{p x p} correlation matrix with user-defined minimum and maximum
correlation values.
}
\examples{
cor_A <- rand_cor_mat(10, min_cor = -0.2, max_cor = 0.8, pos_def = TRUE)
}
