% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_corr_mat.R
\name{rand_cor_mat}
\alias{rand_cor_mat}
\title{Random correlation matrix}
\usage{
rand_cor_mat(p, min_cor = -1, max_cor = 1)
}
\arguments{
\item{p}{A scalar defining the dimensions of the correlation matrix.}

\item{min_cor}{A scalar defining the minimum correlation. By default, min_cor = -1.}

\item{max_cor}{A scalar defining the maximum correlation. By default, max_cor = 1.}
}
\value{
A p x p correlation matrix.
}
\description{
Creates a general \code{p x p} correlation matrix with user-defined maximum and minimum
correlations. If the randomly generated correlation matrix is not positive definite,
the function \link[mbend]{bend} of the package 'mbend' is used with default arguments to turn
the correlation matrix into a positive definite correlation matrix.
}
\examples{
cor_A <- rand_cor_mat(10, min_cor = -0.2, max_cor = 0.8)
}
