% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapperGenerator.R
\name{wrapperGenerator}
\alias{wrapperGenerator}
\title{Wrapper measure generator}
\usage{
wrapperGenerator(learner, resamplingParams, fittingParams)
}
\arguments{
\item{learner}{\itemize{
\item Learner to be used. The models available are the models available in caret: http://topepo.github.io/caret/available-models.html
}}

\item{resamplingParams}{\itemize{
\item Control parameters for evaluating the impact of model tuning parameters. The arguments are the same as those of the caret trainControl function
}}

\item{fittingParams}{\itemize{
\item Control parameters for choose the best model across the parameters. The arguments are the same as those of the caret train function (minus the parameters: x, y, form, data, method and trainControl).
}}
}
\value{
Returns a wrapper function that is used to generate an evaluation measure
}
\description{
Generates a wrapper function to be used as an evaluator \insertCite{kohavi1997}{FSinR}, given a learner algorithm and related customizable parameters \insertCite{caret}{FSinR}. More specifically, the result of calling this function is another function that is used as an evaluator in the search methods, although you can also call it up to generate an evaluation measure individually.
}
\details{
generaWrapper
}
\examples{
# Values for the caret trainControl function
resamplingParams <- list(method = "repeatedcv", repeats = 3)
# Values for the caret train function
fittingParams <- list(preProc = c("center", "scale"), metric="Accuracy", 
                      tuneGrid = expand.grid(k = c(1:20)))
# Generation of the wrapper function
wrapper <- wrapperGenerator("knn", resamplingParams, fittingParams)
# The function call generates the evaluation measure
wrapper(iris, 'Species', c('Sepal.Length', 'Sepal.Width', 'Petal.Length'))
}
\references{
\insertAllCited{}
}
\author{
Alfonso Jiménez-Vílchez

Francisco Aragón Royón
}
