% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectDifference}
\alias{selectDifference}
\title{Select difference}
\usage{
selectDifference(data, class, featureEval, d.threshold = 0.1)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureEval}{\itemize{
\item The measure used to evaluate features
}}

\item{d.threshold}{\itemize{
\item Number between 0 and 1, to calculate the slope
}}
}
\value{
A list is returned containing:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{featuresSelected}{The names of the returned features sorted according to the result of the evaluation measure}
\item{valuePerFeature}{The evaluation measures of the returned features}
}
}
\description{
Selects features (in descending order from the best evaluation measure to the lowest) until evaluation difference is over a threshold.
}
\examples{
## Select Difference for iris dataset (filter method)
# Selects features in descending order as long as the difference between them is less than 0.1
selectDifference(iris, 'Species', chiSquared, 0.1) 
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
