% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequentialSelection.R
\name{sfs}
\alias{sfs}
\title{Sequential Forward Selection}
\usage{
sfs(data, class, featureSetEval, stopCriterion = -1, stop = FALSE)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureSetEval}{\itemize{
\item The measure for evaluate features
}}

\item{stopCriterion}{\itemize{
\item Define a maximum number of iterations. Disabled if the value is -1 (default: -1 )
}}

\item{stop}{\itemize{
\item If true, the function stops if next iteration does not improve current results (default: FALSE)
}}
}
\value{
A list is returned containing:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{bestFitness}{Evaluation measure obtained with the feature selection}
}
}
\description{
The SFS method \insertCite{Whitney1971}{FSinR} starts with an empty set of features and add a single feature at each step with a view to improving the evaluation of the set.
}
\examples{
## sfs method for iris dataset (filter method)
sfs(iris, 'Species', roughsetConsistency)
}
\references{
\insertAllCited{}
}
\author{
Adan M. Rodriguez

Alfonso Jiménez-Vílchez

Francisco Aragón Royón
}
