% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_fsk.R
\name{export_fsk}
\alias{export_fsk}
\title{Exports an object of FSK class as an .fskx file}
\usage{
export_fsk(fsk_object, out_path, check = TRUE)
}
\arguments{
\item{fsk_object}{The instance of FSK2R to be exported.}

\item{out_path}{Path where the file is to be saved.}

\item{check}{Whether checks are made. TRUE by default.}
}
\value{
None
}
\description{
Exports an object of FSK class as an .fskx file
}
\examples{
\donttest{
 path_example <- system.file("extdata", "ToyModelv4.fskx", package = "FSK2R")
 my_fsk <- import_fsk(path_example)
 class(my_fsk)
 export_fsk(my_fsk, out_path=file.path(tempdir(), "out.fskx"))
}

}
