% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RBSmeltErie.R
\docType{data}
\name{RBSmeltErie}
\alias{RBSmeltErie}
\title{Recruitment time-series for Rainbow Smelt in Lake Erie, 1977-1996.}
\format{A data frame of 20 observations on the following 2 variables:
 \describe{
   \item{year}{Year of data.}
   \item{recruits}{Number of recruits (per hour).}
 }}
\source{
from Ontario Ministry of Natural Resources, Fish and Wildlife Branch, 1997. Lake Erie fisheries report 1996.  Lake Erie Committee Meeting,
Great Lakes Fishery Commission, Ann Arbor, Michigan. pp 26.  Obtained from \href{http://ram.biology.dal.ca/~myers/data.html}{Ransom Myers online database}.
}
\description{
Rainbow Smelt (\emph{Osmerus mordax}) recruitment time series for Lake Erie, 1977-1996.
}
\note{
Zeros were changed to 0.1 in 1984, 1987, 1991, and 1994.
}
\section{Topic(s)}{

 \itemize{
   \item Recruitment time-series
 }
}
\examples{
data(RBSmeltErie)
str(RBSmeltErie)
head(RBSmeltErie)
plot(recruits~year,data=RBSmeltErie,type="l")
}
\concept{
Recruitment
}
\keyword{datasets}

