% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksTest.R
\name{ksTest}
\alias{ksTest}
\alias{ksTest.default}
\alias{ksTest.formula}
\alias{ksTest.default}
\alias{ksTest.formula}
\title{Kolmogorov-Smirnov Tests.}
\usage{
ksTest(x, ...)

\method{ksTest}{default}(x, y, ..., alternative = c("two.sided", "less",
  "greater"), exact = NULL)

\method{ksTest}{formula}(x, data = NULL, ..., alternative = c("two.sided",
  "less", "greater"), exact = NULL)
}
\arguments{
\item{x}{A numeric vector of data values or a formula (see details).}

\item{\dots}{Parameters of the distribution specified (as a character string) by \code{y}.}

\item{y}{A numeric vector of data values, a character string naming a cumulative distribution function, or an actual cumulative distribution function.  See \code{\link[stats]{ks.test}}.}

\item{alternative}{A string that indicates the alternative hypothesis.  See \code{\link[stats]{ks.test}}.}

\item{exact}{\code{NULL} or a logical that indicates whether an exact p-value should be computed. See \code{\link[stats]{ks.test}}.  Not available if ties are present, nor for the one-sided two-sample case.}

\item{data}{A data frame that contains the variables in the formula for \code{x}.}
}
\value{
See \code{\link[stats]{ks.test}}.
}
\description{
Performs a one- or two-sample Kolmogorov-Smirnov test.  Includes the option to perform the two-sample test using the formula notation.
}
\details{
This is exactly \code{\link[stats]{ks.test}} except that a formula may be used for the two-sample situation.  The default version is simply a pass through to \code{\link[stats]{ks.test}}.  See \code{\link[stats]{ks.test}} for more details.
}
\examples{
## see ks.test for other examples
x <- rnorm(50)
y <- runif(30)
df <- data.frame(dat=c(x,y),grp=rep(c("X","Y"),c(50,30)))

## one-sample (from ks.test) still works
ksTest(x+2, "pgamma", 3, 2)
ks.test(x+2, "pgamma", 3, 2)

## first two-sample example in ?ks.test
ksTest(x,y)
ks.test(x,y)

## same as above but using data.frame and formula
ksTest(dat~grp,data=df)

}
\seealso{
\code{\link[stats]{ks.test}}.
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\keyword{htest}
