% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBqryCSV.R
\name{DBqryCSV}
\alias{DBqryCSV}
\title{Database - Queries FIA Online Database.}
\usage{
DBqryCSV(sql, states = NULL, sqltables = NULL)
}
\arguments{
\item{sql}{String. A sql query. Must be appropriate sql syntax.}

\item{states}{String vector. Name of state(s) in query. If not by state, set
to NULL.}

\item{sqltables}{String vector. Name of table(s) in sql statement to
download.  The sqltables must match tables in the sql statement (i.e.,
case-sensitive).}
}
\value{
Returns a data frame from resulting query.
}
\description{
Downloads, extracts, and queries compressed comma-delimited file(s) (*.zip)
from FIA DataMart
(https://apps.fs.usda.gov/fia/datamart/CSV/datamart_csv.html).  (Note: must
use SQL syntax).
}
\details{
The compressed data files are downloaded from FIA DataMart; saved to a
temporary space; extracted and imported; and deleted from temporary space.
Accessibility and download time depends on access and speed of internet
connection.
}
\examples{
\dontrun{
# Number of plots by inventory year for the state of Wyoming
sql <- "select INVYR, count(*) AS NBRPLOTS
        from plot
        where statecd=56 group by INVYR"
DBqryCSV(sql = sql,
         states = "Wyoming",
         sqltables = "plot")
}
}
\author{
Tracey S. Frescino
}
\keyword{data}
