% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe.data.prep.R
\name{fe.data.prep}
\alias{fe.data.prep}
\title{Prepares data for model fitting (fe.prov)}
\usage{
fe.data.prep(data, Y.char, Z.char, prov.char, cutoff = 10)
}
\arguments{
\item{data}{a \code{data.frame} including response, provider ID, and covariates, with missing values imputed}

\item{Y.char}{name of the response variable from \code{data} as a character string}

\item{Z.char}{names of covariates from \code{data} as vector of character strings}

\item{prov.char}{name of provider IDs variable as a character string}

\item{cutoff}{cutoff of provider size as an interger, default value is 10}
}
\value{
\code{data.frame}: a data frame sorted by provider IDs with additional
variables 'included', 'no.readm', 'all.readm' and missing values imputed.
}
\description{
\code{fe.data.prep} prepares the data for model fitting with \code{fe.prov} by
taking the data with missing values imputed. Go to
\href{https://github.com/umich-biostatistics/FEprovideR}{Github} for a tutorial.
}
\examples{
data(hospital) # build in data set
# Name input variables and other parameters
cutoff <- 10              # an integer as cutoff of facility (or provider) size with 10 as default
alpha <- 0.05             # significance level
Y.char <- 'Y'
prov.char <- 'prov.ID'
Z.char <- paste0('z', 1:3)

hospital_prepared <- fe.data.prep(hospital, Y.char, Z.char, prov.char, cutoff) # data preparation

}
\references{
He, K., Kalbfleisch, J.D., Li, Y. and Li, Y., 2013. Evaluating hospital
readmission rates in dialysis facilities; adjusting for hospital effects. Lifetime data
analysis, 19(4), pp.490-512.
}
\seealso{
\code{\link{fe.prov}},   \code{\link{test.fe.prov}},
\code{\link{funnel.SRR}},   \code{\link{confint.fe.prov}}
}
