% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_discrete.R
\name{fast.Discrete}
\alias{fast.Discrete}
\alias{fast.Discrete.LR}
\alias{fast.Discrete.PB}
\alias{fast.Discrete.GR}
\title{Fast application of discrete procedures}
\usage{
fast.Discrete.LR(
  counts,
  alternative = "greater",
  input = "noassoc",
  alpha = 0.05,
  zeta = 0.5,
  direction = "sd",
  adaptive = TRUE
)

fast.Discrete.PB(
  counts,
  alternative = "greater",
  input = "noassoc",
  alpha = 0.05,
  zeta = 0.5,
  adaptive = TRUE,
  exact = FALSE
)

fast.Discrete.GR(
  counts,
  alternative = "greater",
  input = "noassoc",
  alpha = 0.05,
  zeta = 0.5,
  adaptive = TRUE
)
}
\arguments{
\item{counts}{a data frame of 2 or 4 columns and any number of lines,
each line representing a 2 x 2 contingency table to
test. The number of columns and what they must contain
depend on the value of the \code{input} argument, see
Details of \code{\link{fisher.pvalues.support}}.}

\item{alternative}{same argument as in \code{\link{fisher.test}}. The three
possible values are \code{"greater"} (default),
\code{"two.sided"} or \code{"less"}; may be abbreviated.}

\item{input}{the format of the input data frame, see Details of
\code{\link[DiscreteFDR]{fisher.pvalues.support}}. The
three possible values are \code{"noassoc"} (default),
\code{"marginal"} or \code{"HG2011"}; may be 
abbreviated.}

\item{alpha}{the target FDP, a number strictly between 0 and 1. For \code{*.fast} kernels, it is only necessary, if \code{stepUp = TRUE}.}

\item{zeta}{the target probability of not exceeding the desired FDP, a number strictly between 0 and 1. If \code{zeta=NULL} (the default), then \code{zeta} is chosen equal to \code{alpha}.}

\item{direction}{a character string specifying whether to conduct a step-up (\code{direction="su"}, the default) or step-down procedure (\code{direction="sd"}).}

\item{adaptive}{a boolean specifying whether to conduct an adaptive procedure or not.}

\item{exact}{a boolean specifying whether to compute the Poisson-Binomial distribution exactly or by a normal approximation.}
}
\value{
A \code{FDX} S3 class object whose elements are:
\item{Rejected}{Rejected raw p-values.}
\item{Indices}{Indices of rejected hypotheses.}
\item{Num.rejected}{Number of rejections.}
\item{Adjusted}{Adjusted p-values (only for step-down direction).}


\item{Method}{A character string describing the used algorithm, e.g. 'Discrete Lehmann-Romano procedure (step-up)'.}
\item{FDP.threshold}{FDP threshold \code{alpha}.}
\item{Exceedance.probability}{Probability \code{zeta} of FDP exceeding \code{alpha}; thus, FDP is being controlled at level \code{alpha} with confidence \code{1 - zeta}.}
\item{Adaptive}{A boolean specifying whether an adaptive procedure was conducted or not.}

\item{Data$raw.pvalues}{The values of \code{raw.pvalues}.}


\item{Data$data.name}{The respective variable names of \code{raw.pvalues} and \code{pCDFlist}.}
}
\description{
Applies the [DLR], [DGR] or [DPB] procedures, without computing the critical
values, to a data set of 2 x 2 contingency tables using Fisher's exact test.
}
\examples{

X1 <- c(4, 2, 2, 14, 6, 9, 4, 0, 1)
X2 <- c(0, 0, 1, 3, 2, 1, 2, 2, 2)
N1 <- rep(148, 9)
N2 <- rep(132, 9)
Y1 <- N1 - X1
Y2 <- N2 - X2
df <- data.frame(X1, Y1, X2, Y2)
df

DLR.sd <- fast.Discrete.LR(counts = df, input = "noassoc")
DLR.sd$Adjusted
summary(DLR.sd)
DLR.su <- fast.Discrete.LR(counts = df, input = "noassoc", direction = "su")
summary(DLR.su)

NDLR.sd <- fast.Discrete.LR(counts = df, input = "noassoc", adaptive = FALSE)
NDLR.sd$Adjusted
summary(NDLR.sd)
NDLR.su <- fast.Discrete.LR(counts = df, input = "noassoc", direction = "su", adaptive = FALSE)
summary(NDLR.su)

DGR <- fast.Discrete.GR(counts = df, input = "noassoc")
DGR$Adjusted
summary(DGR)

NDGR <- fast.Discrete.GR(counts = df, input = "noassoc", adaptive = FALSE)
NDGR$Adjusted
summary(NDGR)

DPB <- fast.Discrete.PB(counts = df, input = "noassoc")
DPB$Adjusted
summary(DPB)

NDPB <- fast.Discrete.PB(counts = df, input = "noassoc", adaptive = FALSE)
NDPB$Adjusted
summary(NDPB)

}
