% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGM.R
\name{BGM}
\alias{BGM}
\title{Separate \eqn{R} From \eqn{X}}
\usage{
BGM(X, R, K = 2, tolerance = 0.001, nmax = 100)
}
\arguments{
\item{X}{a large matrix from which principle components are extracted.}

\item{R}{a numeric vector which we are interesting in, for example interest rates.}

\item{K}{the number of extracted principle components.}

\item{tolerance}{the difference between factors when iterating.}

\item{nmax}{the max iterations, see details.}
}
\value{
the first K principle components, i.e. \eqn{F_t^{(n)}}, not containing the information \code{R}.
}
\description{
\eqn{X} may include some information related with \eqn{R}. The function
extract factors from \code{X} which is not related with \code{R} by iteration
based on Boivin et al. (2009).
}
\details{
The algorithm is as follows:
\enumerate{
\item Extract the first K principal components noted \eqn{F_t^{(0)}} from \code{X}.
\item Regress \code{X} on \eqn{F_t^{(0)}} and \eqn{R_t}, and get regression
coefficients \eqn{\beta_R^{(0)}} of \eqn{R_t}.
\item compute \eqn{X_0^{(0)} = X_t- R_t \beta_R}.
\item Extract the first K principal components noted \eqn{F_t^{(1)}} from
\code{X_t^{(0)}}.
\item repeat step 2 - step 4 until precision you want.
}
}
\examples{
data('regdata')
BGM(X = regdata[,1:115],R = regdata[,ncol(regdata)], K = 2)
}
\references{
Boivin, J., M.P. Giannoni and I. Mihov, Sticky Prices and Monetary Policy: Evidence
from Disaggregated US Data. American Economic Review, 2009. 99(1): p. 350-384.
}
