% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanET.R
\name{PanCoef}
\alias{PanCoef}
\title{Pan Coefficient (K_p)}
\usage{
PanCoef(u_2, RH_mean, FET, type, fetch)
}
\arguments{
\item{u_2}{A numeric scalar that denotes the wind speed at the height 2m above the ground surface [m/s].}

\item{RH_mean}{A numeric scalar that denotes the mean relative humidity. (\eqn{30\% <= RH_mean <= 84\%})}

\item{FET}{A numeric scalar that denotes the fetch, or distance of the identified surface type [m] (\eqn{1m <= FET <= 1000m})
(grass or short green agricultural crop for case A, dry crop or bare soil for case B upwind of the evaporation pan)}

\item{type}{A character string that denotes the type of pan and can take the options "Class A"
for Class A pan and "Colorado" for Colorado sunken pan.}

\item{fetch}{A character string that denotes the fetch state and can take the options "dry" and "green".}
}
\value{
The function returns the value of the pan coefficient.
}
\description{
\code{PanCoef} returns the value of Pan Coefficient (K_p).
}
\details{
This is a function to calculate the pan coefficient used in the pan evaporation method to calculate the reference evapotranspiration.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
PanCoef(u_2 = 2, RH_mean = 50, FET = 3, type = "Class A", fetch = "dry")

}
\seealso{
\code{\link{ETo_Pan}, \link{MeanRH}}.
}
