% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_and_fit_function.R
\name{combine.and.fit}
\alias{combine.and.fit}
\title{Combine and Fit Parameters}
\usage{
combine.and.fit(par, par.names, fit.fn, binary = NULL, default.val = NULL, ...)
}
\arguments{
\item{par}{A named vector containing all parameters that are supposed to be fitted.}

\item{par.names}{The names of all parameters}

\item{fit.fn}{The cost or optimisation function (see \code{\link{famos}} for more details).}

\item{binary}{A vector containing zeroes and ones. Zero indicates that the corresponding parameter is not fitted.}

\item{default.val}{A named list containing the values that the non-fitted parameters should take. If NULL, all non-fitted parameters will be set to zero. Default values can be either given by a numeric value or by the name of the corresponding parameter the value should be inherited from (NOTE: In this case the corresponding parameter entry has to contain a numeric value). Default to NULL.}

\item{...}{Other arguments.}
}
\value{
Returns the value calculated by the user-supplied cost or optimisation function
}
\description{
Combines fitted and non-fitted parameters and calls the fitting function. Serves as a wrapping function for the user-specified fitting function \code{fit.fn} (see \code{\link{famos}}).
}
\examples{
#set parameters and cost function
fit.par <- c(p1 = 2, p2 = 4)
name.par <- c("p1", "p2", "p3")
defaults <- list(p1 = 0, p2 = 2, p3 = 4)
cost.function <- function(parms){
    parms[1] + parms[2] + parms[3]
}

#call combine.and.fit
combine.and.fit(par = fit.par, par.names = name.par, fit.fn = cost.function)
combine.and.fit(par = fit.par, par.names = name.par, fit.fn = cost.function, default.val = defaults)
}
