% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_crit_parms_function.R
\name{set.crit.parms}
\alias{set.crit.parms}
\title{Convert Critical and Swap Sets}
\usage{
set.crit.parms(critical.parameters, all.names)
}
\arguments{
\item{critical.parameters}{A list containing vectors which specify either critical parameter sets or swap parameter sets (see Details).}

\item{all.names}{A vector containing the names of all parameters.}
}
\value{
A list containing the indices of the respective critical or swap sets.
}
\description{
Converts the user-specified list containing the names of the critical or swap parameters into a format that is more convenient for calculations.
}
\details{
Critical sets are parameters sets, of which at least one per set has to be present in each tested model. If a model violates on of the critical conditions, it will not be fitted (see also \code{\link{model.appr}}). On the other hand, swap parameter sets define which parameters are interchangeable. For more information see \code{\link{famos}}.
}
\examples{
#set critical set and names
crits <- list(c("p1", "p2"), c("p5"))
par.names <- c("p1", "p2", "p3", "p4", "p5")
#convert the critical conditions
set.crit.parms(critical.parameters = crits, all.names = par.names)
}
