% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_image.R
\name{plot_image}
\alias{plot_image}
\title{Esta funcao plota imagens. (This function plot the images.)}
\usage{
plot_image(im,r=1,g=2,b=3,band=NULL,col=0,normalize=FALSE,axis=FALSE,
       lim=NULL,title=NULL,flip=TRUE,flop=FALSE,rotate=0,norm=1,
       rasterRGB=FALSE)
}
\arguments{
\item{im}{Este objeto deve conter uma imagem no formato do EBImage ou na forma
de uma matriz, no caso de imagem em escala de cinza (This
 object must contain an image in EBImage format).}

\item{r}{Indica o canal correspondente a cor vermelha para imagens com
extensao '.tif'. O defaut e 1. (Indicates the channel corresponding to
red color for images with the extension '.tif'. The default is 1.)}

\item{g}{Indica o canal correspondente a cor verde para imagens com
extensao '.tif'. O defaut e 2. (Indicates the channel corresponding to
green color for images with the extension '.tif'. The default is 2.)}

\item{b}{Indica o canal correspondente a cor azul para imagens com
extensao '.tif'. O defaut e 3. (Indicates the channel corresponding to
blue color for images with the extension '.tif'. The default is 3.)}

\item{band}{Indica a banda que se deseja plotar. Neste caso nao se precisa
considerar as bandas de R, G e B simultaneamente.}

\item{col}{Pode ser um valor numerico variando entre 0 e 6 ou uma paleta de cores
obtida pela funcao `colorRampPalette`. Se for 0 sera considerada a representacao
da imagem monocromatica em escala de cinza. Valores entre 1 e 6 indicam outras
paletas de cores para a representacao. (It can be a numerical value ranging from
0 to 6 or a color palette 'obtained by the `colorRampPalette` function. If it is
0, the representation of the monochromatic image in gray scale will be considered.
Values between 1 and 6 indicate other color palettes for the representation. )}

\item{normalize}{Se for TRUE a imagem sera normalizada para que os valores dos pixels
variem entre 0 e 1 (If TRUE, the image will be normalized so that the pixel values
 vary between 0 and 1).}

\item{axis}{Se for FALSE nao aparecera os eixos no grafico (If it is FALSE, the axes will
not appear in the graph)}

\item{lim}{Vetor contendo quatro valores correspondentes aos limites que apareceral nos eixos do grafico
(Vector containing four values corresponding to the limits that will appear on the graph axes)}

\item{title}{Titulo do grafico (chart title).}

\item{flip}{Inverter a imagem (invert the image)}

\item{flop}{Inverter a imagem (invert the image)}

\item{rotate}{Valor numerico com o angulo para a rotacao da imagem
(Numeric value with angle for image rotation)}

\item{norm}{Numero pelo qual os valores dos pixels deverao ser divididos para variar entre 0 e 1
(Number by which pixel values should be divided to vary between 0 and 1).}

\item{rasterRGB}{Se a imagem for em TIF com uma unica banda deve ser FALSE.
Se houver 3 ou mais bandas deve ser TRUE (If the image is in TIF with a
single band it must be FALSE. If there are 3 or more bands it must be TRUE).}
}
\value{
Apresenta a imagem contida no objeto im.
}
\description{
Esta funcao permite plotar a imagem (This function allows you to
 view the image).
}
\examples{

#library(ExpImage)
#library(EBImage)
#Carregar imagem de exemplo
im=read_image(example_image(2),plot=FALSE)
im=resize_image(im,w = 300,plot = FALSE)
plot_image(im)

#Representado imagens em escalas de cinza
im2 = gray_scale(im,"r")
plot_image(im2)
#Utilizando uma paleta de cores para a melhor visualizacao
plot_image(im2,col=2)
plot_image(im2,col=3,axis=TRUE)




\donttest{

#########################################################
#########################################################
#' #' ########################################################
###' Abrindo o endereco de bandas de imagens de satelite
########################################################
end1=example_image(14) #Banda de azul
end2=example_image(15) #Banda de verde
end3=example_image(16) #Banda de vermelho
end4=example_image(17) #Banda de IR
end5=example_image(18) #Banda de SWIR

########################################################
###' Abrindo bandas de imagens de satelite
########################################################
B1=read_image(end1,plot=TRUE)
B2=read_image(end2,plot=TRUE)
B3=read_image(end3,plot=TRUE)
B4=read_image(end4,plot=TRUE)
B5=read_image(end5,plot=TRUE)

########################################################
###' Juntando as bandas em uma imagem
########################################################
im=join_bands(imgs = list(B1,B2,B3,B4,B5))
tif_info(im)
plot_image(im,r=3,g=2,b=1,rasterRGB=TRUE)
}
}
\seealso{
\code{\link{read_image}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
