% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fat2.dic.r
\name{fat2.dic}
\alias{fat2.dic}
\title{Fatorial duplo em DIC}
\usage{
fat2.dic(
  fator1,
  fator2,
  resp,
  quali = c(TRUE, TRUE),
  mcomp = "tukey",
  fac.names = c("F1", "F2"),
  sigT = 0.05,
  sigF = 0.05
)
}
\arguments{
\item{fator1}{Vetor numerico ou complexo contendo os niveis
do fator 1.}

\item{fator2}{Vetor numerico ou complexo contendo os niveis
do fator 2.}

\item{resp}{Vetor numerico ou complexo contendo a variavel
resposta.}

\item{quali}{Logico, se TRUE (default) na primeira posicao,
os niveis do fator 1 sao entendidos como qualitativos, se
FALSE, quantitativos; da mesma forma, a segunda posicao e
referente aos niveis do fator 2.}

\item{mcomp}{Permite escolher o teste de comparacao multipla;
o \emph{default} e o teste de Tukey, contudo tem-se como
outras opcoes: o teste LSD ('lsd'), o teste LSDB ('lsdb'),
o teste de Duncan ('duncan'), o teste de SNK ('snk'), o
teste de Scott-Knott ('sk'), o teste de comparacoes
multiplas bootstrap ('ccboot') e o teste de Calinski e
Corsten baseado na distribuicao F ('ccf').}

\item{fac.names}{Permite nomear os fatores 1 e 2.}

\item{sigT}{Significancia a ser adotada pelo teste de
comparacao multipla de medias; o default e 5\%.}

\item{sigF}{Significancia a ser adotada pelo teste F da
ANAVA; o default e 5\%.}
}
\value{
Sao retornados os valores da analise de variancia
do DIC em questao, o teste de
normalidade de Shapiro-Wilk para os residuos do modelo, o
ajuste de modelos de regressao (caso de tratamentos
quantitativos) ou os testes de comparacao de medias (caso de
tratamentos qualitativos): teste de Tukey, teste de Duncan,
teste t de Student (LSD), teste t de Bonferroni, teste de
Student-Newman-Keuls (SNK), teste de Scott-Knott e teste de
comparacoes multiplas bootstrap; com o desdobramento da
interacao, caso esta seja significativa.
}
\description{
\code{fat2.dic} Analisa experimentos em fatorial duplo
em Delineamento Inteiramente
Casualizado balanceado, considerando o modelo fixo.
}
\details{
Os argumentos sigT e mcomp so serao utilizados
quando os tratamentos forem qualitativos.
}
\note{
O \code{\link{graficos}} pode ser usado para
construir os graficos da regressao e o
\code{\link{plotres}} para analise do residuo da anava.
}
\examples{
data(ex4)
attach(ex4)
fat2.dic(revol,esterco,zn,quali=c(FALSE,TRUE),mcomp="tukey",
fac.names=c("Revolvimento","Esterco"),sigT = 0.05,
sigF = 0.05)
}
\references{
HEALY, M. J. R. The analysis of a factorial
experiment with additional treatments. Journal of
Agricultural Science, Cambridge, v. 47, p. 205-206.
1956.
}
\seealso{
\code{\link{fat2.dic}}, \code{\link{fat2.dbc}},
\code{\link{fat3.dic}}, \code{\link{fat3.dbc}},
\code{\link{fat2.ad.dic}}, \code{\link{fat2.ad.dbc}},
\code{\link{fat3.ad.dic}} and \code{\link{fat3.ad.dbc}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Portya Piscitelli Cavalcanti
}
