% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{trunc_opts}
\alias{trunc_opts}
\title{Truncation Distribution Options}
\usage{
trunc_opts(dist = Fixed(0), default_cdf_cutoff = 0.001, weight_prior = FALSE)
}
\arguments{
\item{dist}{A delay distribution or series of delay distributions reflecting
the truncation. It can be specified using the probability distributions
interface in \code{EpiNow2} (See \code{?EpiNow2::Distributions}) or estimated using
\code{\link[=estimate_truncation]{estimate_truncation()}}, which returns a \code{dist} object, suited
for use here out-of-box. Default is a fixed distribution with maximum 0, i.e.
no truncation.}

\item{default_cdf_cutoff}{Numeric; default CDF cutoff to be used if an
unconstrained distribution is passed as \code{dist}. If \code{dist} is already
constrained by having a maximum or CDF cutoff this is ignored.}

\item{weight_prior}{Logical; if TRUE, the truncation prior will be weighted
by the number of observation data points, in doing so approximately placing
an independent prior at each time step and usually preventing the
posteriors from shifting. If FALSE (default), no weight will be applied,
i.e. the truncation distribution will be treated as a single parameter.}
}
\value{
A \verb{<trunc_opts>} object summarising the input truncation
distribution.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Returns a truncation distribution formatted for usage by
downstream functions. See \code{\link[=estimate_truncation]{estimate_truncation()}} for an approach to
estimate these distributions.
}
\examples{
# no truncation
trunc_opts()

# truncation dist
trunc_opts(dist = LogNormal(mean = 3, sd = 2, max = 10))
}
\seealso{
\code{\link[=convert_to_logmean]{convert_to_logmean()}} \code{\link[=convert_to_logsd]{convert_to_logsd()}}
\code{\link[=bootstrapped_dist_fit]{bootstrapped_dist_fit()}} \code{\link{Distributions}}
}
