% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{fix_dist}
\alias{fix_dist}
\title{Fix the parameters of a \verb{<dist_spec>}}
\usage{
fix_dist(x, strategy = c("mean", "sample"))
}
\arguments{
\item{x}{A \verb{<dist_spec>}}

\item{strategy}{Character; either "mean" (use the mean estimates of the
mean and standard deviation) or "sample" (randomly sample mean and
standard deviation from uncertainty given in the \verb{<dist_spec>}}
}
\value{
A \verb{<dist_spec>} object without uncertainty
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
If the given \verb{<dist_spec>} has any uncertainty, it is removed and the
corresponding distribution converted into a fixed one.
}
\examples{
# An uncertain gamma distribution with mean 3 and sd 2
dist <- LogNormal(
  meanlog = Normal(3, 0.5), sdlog = Normal(2, 0.5), max = 20
)

fix_dist(dist)
}
