% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendo.R
\name{as.phylo.transmat}
\alias{as.phylo.transmat}
\title{Convert transmat Infection Tree into a phylo Object}
\usage{
\method{as.phylo}{transmat}(x, vertex.exit.times, ...)
}
\arguments{
\item{x}{An object of class \code{transmat}, the output from
\code{\link{get_transmat}}.}

\item{vertex.exit.times}{Optional numeric vector providing the time of
departure of vertices, to be used to scale the lengths of branches
reaching to the tips. Index position on vector corresponds to network
id. NA indicates no departure, so branch will extend to the end of the
tree.}

\item{...}{Further arguments (unused).}
}
\value{
A \code{phylo} class object.
}
\description{
Converts a transmission matrix from the \code{get_transmat}
             function into a \code{phylo} class object.
}
\details{
Converts a \code{\link{transmat}} object containing information about the
history of a simulated infection into a \code{\link{phylo}} object
representation suitable for plotting as a tree with
\code{\link[ape]{plot.phylo}}. Each infection event becomes a 'node'
(horizontal branch) in the resulting \code{phylo} tree, and each network
vertex becomes a 'tip' of the tree. The infection events are labeled with the
vertex ID of the infector to make it possible to trace the path of infection.

The infection timing information is included to position the phylo-nodes,
with the lines to the tips drawn to the max time value +1 (unless
\code{vertex.exit.times} are passed in it effectively assumes all vertices
are active until the end of the simulation).

If the \code{transmat} contains multiple infection seeds (there are multiple
trees with separate root nodes), this function will return a list of class
\code{multiPhylo}, each element of which is a \code{phylo} object. See
\code{\link[ape]{read.tree}}.
}
\examples{
set.seed(13)

# Fit a random mixing TERGM with mean degree of 1 and mean edge
# duration of 20 time steps
nw <- network_initialize(n = 100)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
est <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

# Parameterize the epidemic model as SI with one infected seed
param <- param.net(inf.prob = 0.5)
init <- init.net(i.num = 1)
control <- control.net(type = "SI", nsteps = 40, nsims = 1, verbose = FALSE)

# Simulate the model
mod1 <- netsim(est, param, init, control)

# Extract the transmission matrix
tm <- get_transmat(mod1)
head(tm, 15)

# Convert to phylo object and plot
tmPhylo <- as.phylo.transmat(tm)
par(mar = c(1,1,1,1))
plot(tmPhylo, show.node.label = TRUE,
              root.edge = TRUE,
              cex = 0.75)

}
