% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/el_cuml.R
\name{get_cumulative_edgelist}
\alias{get_cumulative_edgelist}
\title{Get a Cumulative Edgelist From a Specified Network}
\usage{
get_cumulative_edgelist(dat, network)
}
\arguments{
\item{dat}{a Master list object for \code{netsim}.}

\item{network}{Numerical index of the network from which the cumulative
edgelist should be extracted.}
}
\value{
A cumulative edgelist in \code{data.frame} form with 4 columns:
\itemize{
  \item \code{head}: the unique ID see \code{get_unique_ids}) of the
        head node on the edge.
  \item \code{tail}: the unique ID see \code{get_unique_ids}) of the
        tail node on the edge.
  \item \code{start}: the time step in which the edge started.
  \item \code{stop}: the time step in which the edge stopped; if ongoing,
        then \code{NA} is returned.
}
}
\description{
Get a Cumulative Edgelist From a Specified Network
}
