% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.inputs.R
\name{update_params}
\alias{update_params}
\title{Update Model Parameters for Stochastic Network Models}
\usage{
update_params(x, new.param.list)
}
\arguments{
\item{x}{Object of class \code{param.net}, output from function of same name.}

\item{new.param.list}{Named list of new parameters to add to original
parameters.}
}
\value{
An updated list object of class \code{param.net}, which can be passed to
EpiModel function \code{\link{netsim}}.
}
\description{
Updates epidemic model parameters originally set with
             \code{\link{param.net}} and adds new parameters.
}
\details{
This function allows for updating any original parameters specified with
\code{\link{param.net}} and adding new parameters. This function would be
used when the inputs to \code{\link{param.net}} may be a long list of
fixed model parameters that may need supplemental replacements or additions
for particular model runs (e.g., changing an intervention efficacy parameter
but leaving all other parameters fixed).

The \code{new.param.list} object should be a named list object that may
named parameters matching those already in \code{x} (in which case those
original parameter values will be replaced) or not matching (in which case
new parameters will be added to \code{x}).
}
\examples{
x <- param.net(inf.prob = 0.5, act.rate = 2)
y <- list(inf.prob = 0.75, dx.rate = 0.2)
z <- update_params(x, y)
print(z)

}
