% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.netdx}
\alias{plot.netdx}
\title{Plot Dynamic Network Model Diagnostics}
\usage{
\method{plot}{netdx}(x, type = "formation", sim, stats, sim.col, sim.lwd,
  sim.lty = 1, targ.col, targ.lwd = 2, targ.lty = 2, xlim, ylim,
  plots.joined, plot.leg = TRUE, ...)
}
\arguments{
\item{x}{an \code{EpiModel} object of class \code{netdx}.}

\item{type}{plot type, with options of \code{"formation"} for network
model formation statistics, or \code{"duration"} for dissolution model
statistics for average edge duration.}

\item{sim}{vector of simulation numbers to plot, with the default to plot
all simulations.}

\item{stats}{network statistics to plot, among those specified in the call
to \code{\link{netdx}}, with the default to plot all statistics
contained in the object.}

\item{sim.col}{vector of standard R colors for individual simulation lines,
with default colors based on \code{RColorBrewer} color palettes.}

\item{sim.lwd}{line width for individual simulation lines, with defaults based
on number of simulations (more simulations results in thinner lines).}

\item{sim.lty}{line type for the individual simulation lines.}

\item{targ.col}{vector of standard R colors for target statistic lines, with
default colors based on \code{RColorBrewer} color palettes.}

\item{targ.lwd}{line width for the line showing the target statistic values.}

\item{targ.lty}{line type for the line showing the target statistic values.}

\item{xlim}{x-axis scale limits for plot, with defaults based on model time
steps.}

\item{ylim}{y-axis scale limits for plot, with defaults based on the range of
data. This is always set automatically when \code{plots.joined=TRUE}.}

\item{plots.joined}{if \code{TRUE}, combine all target statistics in one plot,
otherwise use one plot window per target statistic.}

\item{plot.leg}{if \code{TRUE}, show legend (only if \code{plots.joined=TRUE})}

\item{...}{additional arguments passed to main plot windows.}
}
\description{
Plots dynamic network model diagnostics calculated in
             \code{netdx}.
}
\details{
The plot function for \code{netdx} objects will generate plots of two types of
model diagnostic statistics that run as part of the diagnostic tools within
that function. The \code{formation} plot shows the summary statistics
requested in \code{nwstats.formula}, where the default includes those
statistics in the network model formation formula specified in the original
call to \code{\link{netest}}.

The \code{duration} plot shows the average age of existing edges at each time
step, up until the maximum time step requested. This is calculated with the
\code{\link{edgelist_meanage}} function. The age is used as an estimator of
the average duration of edges in the equilibrium state.

The \code{plots.joined} argument will control whether the target statistics
in the \code{formation} plot are joined in one plot or plotted separately.
The default is based on the number of network statistics requested. The
layout of the separate plots within the larger plot window is also based on
the number of statistics.
}
\examples{
\dontrun{
# Network initialization and model parameterization
nw <- network.initialize(100, directed = FALSE)
nw <- set.vertex.attribute(nw, "sex", rbinom(100, 1, 0.5))
formation <- ~ edges + nodematch("sex")
dissolution <- ~ offset(edges)
target.stats <- c(50, 40)
coef.diss <- dissolution_coefs(dissolution, duration = 10)

# Estimate the model
est <- netest(nw,
              formation,
              dissolution,
              target.stats,
              coef.diss,
              verbose = FALSE)

# Run diagnostics
dx <- netdx(est,
            nsims = 10,
            nsteps = 100,
            nwstats.formula = ~ edges + meandeg + concurrent +
                                nodefactor("sex", base = 0) +
                                nodematch("sex"),
            verbose = FALSE)

# Formation statistics plots, joined and separate
plot(dx, type = "formation")
plot(dx, type = "formation", plots.joined = TRUE)
plot(dx, type = "formation", sim = 2:5)
plot(dx, type = "formation", plots.joined = FALSE,
     stats = c("edges", "concurrent"))
plot(dx, type = "formation", stats = "nodefactor.sex.0",
     sim = 1, sim.lwd = 5, sim.col = "darkmagenta")

# Duration statistics plot
plot(dx, type = "duration")
plot(dx, type = "duration", sim = 1)
plot(dx, type = "duration", sim = 10,
     sim.col = "steelblue", sim.lwd = 3,
     targ.lty = 1, targ.lwd = 0.5)
}
}
\seealso{
\code{\link{netdx}}
}
\keyword{plot}

