% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{otu.vector}
\alias{otu.vector}
\title{Convert a Set of Sequence Environments into a Vector}
\usage{
otu.vector(df, aa = "all")
}
\arguments{
\item{df}{a dataframe containing the sequence environment of a species (as the one returned by the function env.sp()).}

\item{aa}{the amino acid(s) to be used to encoded the species.}
}
\value{
A matrix representing the species. This matrix can be converted into a vector representing the target species just typing as.vector(matrix). Each coordinate is the frequency of a given amino acid at a certain position from the environment (see details).
}
\description{
Converts a set of sequence environments into a vector.
}
\details{
The dimension of the vector representing the species will depend on the settings. For instance, if we choose a single amino acid and a radius of 10 for the sequence environment, then we will get a vector of dimension 400 (20 amino acids x 20 positions). If we opt for the 20 amino acids and r = 10, then the vector will be of dimension 8000 (400 for each amino acid * 20 amino acids). Please, note that r is selected in the function env.sp() that will provide the input dataframe for the current function.
}
\examples{
data(bovids)
cow = env.sp(bovids, "Bos_taurus")
otu.vector(cow)
}
\seealso{
env.sp(), otu.space()
}
