% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biEmcdf.R
\name{Biemcdf}
\alias{Biemcdf}
\title{Computes bivariate empirical joint distribution}
\usage{
Biemcdf(data)
}
\arguments{
\item{data}{a numeric matrix with two columns.}
}
\value{
a matrix of values of empirical joint CDF function, where rows and columns are the sorted variables.
Columns are the first variable, and rows are the second variable.
}
\description{
This function computes empirical joint distribution (joint CDF) table with dynamical programming.
}
\details{
This is an optimization for bivariate data.
}
\examples{
n = 10^2
set.seed(123)
x = rnorm(n)
y = rnorm(n)
data = cbind(x, y)
Biemcdf(data)

}

