% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/algorithms.R
\name{ra3}
\alias{ra3}
\title{RA3 Niche Overlap Randomization Algorithm}
\usage{
ra3(speciesData = matrix(rpois(80, 1), nrow = 10))
}
\arguments{
\item{speciesData}{a resource utilization matrix (rows = species, columns = discrete
resource states) filled with non-negative real numbers.}
}
\value{
Returns a random utilization matrix with the same dimensions as the
input matrix.
}
\description{
Randomizes a numeric utilization matrix speciesData by
reshuffling the elements within each row.
}
\details{
The resource utilization matrix (rows = species, columns = discrete
resource categories) may include zeroes, but no negative numbers or missing
values. Relative resource within a species is first calculated, so the rows
need not sum to 1.0.
}
\note{
This algorithm retains the niche breadth and zero states for each
species, but randomizes the assignment of each utilization value to a
different niche category. It performs effectively in simulation studies and
is recommended for analysis of niche overlap patterns.
}
\examples{
ranUtil <- ra3(speciesData=matrix(rpois(40,0.5),nrow=8))
}
\references{
Winemiller, K.O. and E.R. Pianka. 1990. Organization in natural
assemblages of desert lizards and tropical fishes. Ecological Monographs
60: 27-55.
}

