% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/metrics.R
\name{min_diff}
\alias{min_diff}
\title{MinDiff Size Overlap Metric}
\usage{
min_diff(m = runif(20))
}
\arguments{
\item{m}{a vector of non-negative trait measures, one for each species}
}
\value{
Returns the minimum difference between adjacent, ordered values.
}
\description{
Function to calculate the minimum absolute size difference
between species within an assemblage.
}
\details{
Although this index is typically used to examine body size differences
in an animal assemblage, it could be used for any morphological index,
such as beak size, or for a phenological "trait", such as peak flowering time in a plant
assemblage.
}
\examples{
MinSizeDif <- min_diff(rgamma(20,shape=3,scale=2))
}
\references{
Simberloff, D. and W.J. Boecklen. 1981. Santa Rosalia reconsidered: size
ratios and competition. Evolution 35: 1206-1228.
}

