% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETRep_Functions.R
\name{intrinsic_Transformation_Elliptical_Tubes}
\alias{intrinsic_Transformation_Elliptical_Tubes}
\title{Intrinsic Transformation Between Two ETReps}
\usage{
intrinsic_Transformation_Elliptical_Tubes(
  tube1,
  tube2,
  type = "sizeAndShapeAnalysis",
  numberOfSteps = 5,
  plotting = TRUE,
  colorBoundary = "blue"
)
}
\arguments{
\item{tube1}{List containing details of the first ETRep.}

\item{tube2}{List containing details of the second ETRep.}

\item{type}{String defining the type of analysis as sizeAndShapeAnalysis or shapeAnalysis}

\item{numberOfSteps}{Integer, number of transformation steps.}

\item{plotting}{Logical, enables visualization during transformation (default is TRUE).}

\item{colorBoundary}{String defining the color of the e-tube}
}
\value{
List containing intermediate ETReps.
}
\description{
Performs the intrinsic transformation from one ETRep to another.
}
\examples{
\donttest{
# Load tubes
data("tube_A")
data("tube_B")
numberOfSteps <- 10
transformation_Tubes<-
  intrinsic_Transformation_Elliptical_Tubes(
    tube1 = tube_A,tube2 = tube_B,
    numberOfSteps = numberOfSteps,
    plotting = FALSE)
# Plotting
for (i in 1:length(transformation_Tubes)) {
  plot_Elliptical_Tube(tube = transformation_Tubes[[i]],
  plot_frames = FALSE,plot_skeletal_sheet = FALSE
  ,plot_r_project = FALSE,
  plot_r_max = FALSE,
  add = FALSE)
}
}
}
