% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsi.lr.v1.R
\name{plsi.lr.v1}
\alias{plsi.lr.v1}
\title{Partial linear single index linear regression for scalar outcome}
\usage{
plsi.lr.v1(
  data,
  Y.name,
  X.name,
  Z.name,
  spline.num,
  spline.degree,
  initial.random.num
)
}
\arguments{
\item{data}{A data set}

\item{Y.name}{Variable name for scalar outcome}

\item{X.name}{Variable name vector for exposures}

\item{Z.name}{Variable name vector for confounders}

\item{spline.num}{A number representing the degree of freedom of B-spline basis for link function}

\item{spline.degree}{A number representing the degree of the piece-wise polynomial of B-spline basis for link function}

\item{initial.random.num}{A number representing the number of random initials used in the function}
}
\value{
A list of model estimation and prediction results
}
\description{
Partial linear single index linear regression for scalar outcome
}
\examples{
\donttest{
# example to run the function
data(nhanes.new)
dat <- nhanes.new

# specify variable names
Y.name <- "log.triglyceride"
X.name <- c("X1_trans.b.carotene", "X2_retinol", "X3_g.tocopherol", "X4_a.tocopherol",
            "X5_PCB99", "X6_PCB156", "X7_PCB206",
            "X8_3.3.4.4.5.pncb", "X9_1.2.3.4.7.8.hxcdf", "X10_2.3.4.6.7.8.hxcdf")
Z.name <- c("AGE.c", "SEX.Female", "RACE.NH.Black",
           "RACE.MexicanAmerican", "RACE.OtherRace", "RACE.Hispanic" )

# specify spline degree of freedom
spline.num = 5
# specify spline degree
spline.degree = 3
# specify number of random initials for estimation
initial.random.num = 1

# run the model
set.seed(2023)
model_1 <- plsi.lr.v1(data = dat, Y.name = Y.name, X.name = X.name, Z.name = Z.name,
                      spline.num, spline.degree, initial.random.num)
}
}
\author{
Yuyan Wang
}
\keyword{plsi.lr}
