% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{chkp}
\alias{chkp}
\alias{chkp,binClst-method}
\title{Check labeling profile}
\usage{
chkp(obj, ...)

\S4method{chkp}{binClst}(obj, ctrlLbls = NULL, ctrlClrs = NULL,
  ctrlLgnd = NULL, lims = NULL)
}
\arguments{
\item{obj}{A \link{binClst_instance}.}

\item{...}{Parameters \code{ctrLbls}, \code{ctrlClrs}, \code{ctrlLgnd} and
  \code{lims} are optional.}

\item{ctrlLbls}{A numeric vector with the control labels or a string
  specifying one of 'height', 'azimuth' or 'both' solar covarites. By
  default, for a \link{binClstPath_instance} it is set to the solar height
  covariate, regardless it has been used or not for the clustering.}

\item{ctrlClrs}{A vector of colors to depict the control labelling. At least
  one colour should be specified for each different control label. By default
  white/grey colours are used for the default control labels.}

\item{ctrlLgnd}{A vector of strings identifying the labels for the legend of
  the plot. They are automatically generated for the solar covariates.}

\item{lims}{A numeric vector with lower and upper bounds to limit the plot.}
}
\description{
Plots the labeling profile of a
  \link{binClst_instance} against a control variable (e.g. environmental
  information) depicted as background coloured bars.
}
\examples{
# -- apply EMbC to \\code{expth} --
mybcp <- stbc(expth)
# -- plot the labeling profile against 'both' solar covariates --
chkp(mybcp,ctrlLbls='both',ctrlClrs=RColorBrewer::brewer.pal(8,'Oranges')[1:4])
}

