% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateDataTemporalMap.R
\name{estimateDataTemporalMap}
\alias{estimateDataTemporalMap}
\title{Estimates \code{DataTemporalMap} objects from raw data}
\usage{
estimateDataTemporalMap(data = NULL, dateColumnName = NULL,
  period = "month", startDate = NULL, endDate = NULL,
  supports = NULL, numericVariablesBins = 100,
  numericSmoothing = TRUE, dateGapsSmoothing = FALSE,
  verbose = FALSE)
}
\arguments{
\item{data}{a \code{data.frame} containing as many rows as individuals, and as many columns as the 
analysis variables plus the individual acquisition date.}

\item{dateColumnName}{a string indicating the name of the column in \code{data} containing the 
analysis date variable.}

\item{period}{the period at which to batch data for the analysis from "week", "month" and "year", 
with "month" as default.}

\item{startDate}{a Date object indicating the date at which to start the analysis, in case of being 
different from the first chronological date in the date column (the default).}

\item{endDate}{a Date object indicating the date at which to end the analysis, in case of being 
different from the last chronological date in the date column (the default).}

\item{supports}{a List of objects containing the support of the data distributions for each variable, 
in classes \code{numeric}, \code{integer}, \code{character}, or \code{factor} (accordingly to the 
variable type), and where the name of the list element must correspond to the column name of its 
variable. If not provided it is automatically estimated from data.}

\item{numericVariablesBins}{the number of bins at which to define the frequency/density histogram 
for numerical variables when their support is not provided, 100 as default.}

\item{numericSmoothing}{a logical value indicating whether a Kernel Density Estimation smoothing 
(Gaussian kernel, default bandwidth) is to be applied on numerical variables (the default) or a 
traditional histogram instead. See ?density for further details.}

\item{dateGapsSmoothing}{a logical value indicating whether a linear smoothing is applied to those 
time batches without data, by default gaps are filled with NAs.}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get an on-time log from the 
function.}
}
\value{
A \code{DataTemporalMap} object.
}
\description{
Estimates a \code{DataTemporalMap} from a \code{data.frame} containing individuals in rows and the 
variables in columns, being one of these columns the analysis date (typically the acquisition date). 
Will return a \code{DataTemporalMap} object or a \code{list} of \code{DataTemporalMap} objects 
depending on the number of analysis variables.
}
\examples{
#Load the file 
dataset <- read.csv2(system.file("extdata",
                                   "nhdsSubset.csv",
                                   package="EHRtemporalVariability"), 
                     sep  = ",",
                     header = TRUE, 
                     na.strings = "", 
                     colClasses = c( "character", "numeric", "factor",
                                     "numeric" , rep( "factor", 22 ) ) )
#Format the date
datasetFormatted <- EHRtemporalVariability::formatDate( input         = dataset,
                                            dateColumn    = "date",
                                            dateFormat    = "\%y/\%m")

#Apply the estimateDataTemporalMap
probMaps <- estimateDataTemporalMap( data           = datasetFormatted, 
                                     dateColumnName = "date", 
                                     period         = "month")
\dontrun{

For a larger example download the following .csv dataset and continue the steps as above:

gitHubUrl  <- 'http://github.com/'
gitHubPath <- 'hms-dbmi/EHRtemporalVariability-DataExamples/'
gitHubFile <- 'raw/master/nhdsSubset.csv'
inputFile  <-  paste0(gitHubUrl, gitHubPath, gitHubFile)

dataset <- read.csv2( inputFile, 
                     sep  = ",",
                     header = TRUE, 
                     na.strings = "", 
                     colClasses = c( "character", "numeric", "factor",
                                     "numeric" , rep( "factor", 22 ) ) ) 
}
}
